/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.block;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;

public class CraftJukebox
extends CraftBlockEntityState<JukeboxBlockEntity>
implements Jukebox {
    public CraftJukebox(World world, JukeboxBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            CraftWorld world = (CraftWorld)this.getWorld();
            Material record = this.getPlaying();
            if (record == Material.AIR) {
                this.getWorldHandle().m_7731_(this.getPosition(), (BlockState)Blocks.f_50131_.m_49966_().m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                this.getWorldHandle().m_7731_(this.getPosition(), (BlockState)Blocks.f_50131_.m_49966_().m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(true)), 3);
            }
            world.playEffect(this.getLocation(), Effect.RECORD_PLAY, record);
        }
        return result;
    }

    @Override
    public Material getPlaying() {
        return this.getRecord().getType();
    }

    @Override
    public void setPlaying(Material record) {
        if (record == null || CraftMagicNumbers.getItem(record) == null) {
            record = Material.AIR;
        }
        this.setRecord(new ItemStack(record));
    }

    @Override
    public ItemStack getRecord() {
        net.minecraft.world.item.ItemStack record = ((JukeboxBlockEntity)this.getSnapshot()).m_59524_();
        return CraftItemStack.asBukkitCopy(record);
    }

    @Override
    public void setRecord(ItemStack record) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(record);
        ((JukeboxBlockEntity)this.getSnapshot()).m_59517_(nms);
        this.data = nms.m_41619_() ? (BlockState)this.data.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(false)) : (BlockState)this.data.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public boolean isPlaying() {
        return (Boolean)this.getHandle().m_61143_((Property)JukeboxBlock.f_54254_);
    }

    @Override
    public void stopPlaying() {
        this.getWorld().playEffect(this.getLocation(), Effect.RECORD_PLAY, Material.AIR);
    }

    @Override
    public boolean eject() {
        this.ensureNoWorldGeneration();
        BlockEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof JukeboxBlockEntity)) {
            return false;
        }
        JukeboxBlockEntity jukebox = (JukeboxBlockEntity)tileEntity;
        boolean result = !jukebox.m_59524_().m_41619_();
        CraftWorld world = (CraftWorld)this.getWorld();
        ((JukeboxBlock)Blocks.f_50131_).m_54260_((Level)world.getHandle(), this.getPosition());
        return result;
    }
}

